/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;

public class Canvas extends Composite {
	Caret caret;
	IME ime;

Canvas () {
}
	
public Canvas (Composite parent, int style) {
	super (parent, style);
}

public Caret getCaret () {
	checkWidget ();
	return caret;
}

public IME getIME () {
	checkWidget();
    return ime;
}

public void drawBackground (GC gc, int x, int y, int width, int height) {
	checkWidget ();
	if (gc == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (gc.isDisposed ()) error (SWT.ERROR_INVALID_ARGUMENT);
	Control control = findBackgroundControl ();
	if (control != null) {
//		control.fillBackground (handle, gc.handle, new Rectangle (x, y, width, height));
	} else {
		gc.fillRectangle (x, y, width, height);
	}
}

public void scroll (int destX, int destY, int x, int y, int width, int height, boolean all) {
	checkWidget();
	if (width <= 0 || height <= 0) return;
	int deltaX = destX - x, deltaY = destY - y;
	if (deltaX == 0 && deltaY == 0) return;
//	boolean isFocus = caret != null && caret.isFocusCaret ();
//	if (isFocus) caret.killFocus ();
//	Rectangle clientRect = getClientArea ();
//	Rectangle sourceRect = new Rectangle (x, y, width, height);
//	if (sourceRect.intersects (clientRect)) {
//		update (all);
//	}
//	Control control = findBackgroundControl ();
	
//	if (control != null && control.backgroundImage != null) {
//		redrawWidget (handle, x, y, width, height, false);
//		redrawWidget (handle, destX, destY, width, height, false);
//	} else {
//	    GC gc = new GC (this);
//	    gc.copyArea (x, y, width, height, destX, destY);
//	    gc.dispose ();
//	}
	redrawWidget (0, 0, (int)object.width, (int)object.height, false);
    if (all) {
		Control [] children = _getChildren ();
		for (int i=0; i<children.length; i++) {
			Control child = children [i];
			Rectangle rect = child.getBounds ();
			if (Math.min(x + width, rect.x + rect.width) >= Math.max (x, rect.x) && 
				Math.min(y + height, rect.y + rect.height) >= Math.max (y, rect.y)) {
					child.setLocation (rect.x + deltaX, rect.y + deltaY);
			}
		}
	}
//	if (isFocus) caret.setFocus ();
}

void releaseChildren (boolean destroy) {
	if (caret != null) {
		caret.release (false);
		caret = null;
	}
	if (ime != null) {
		ime.release (false);
		ime = null;
	}
	super.releaseChildren (destroy);
}
boolean sendFocusEvent (int type) {
	if (caret != null) {
		if (type == SWT.FocusIn) {
			caret.setFocus();
		} else {
			caret.killFocus();
		}
	}
	return super.sendFocusEvent (type);
}

public void setCaret (Caret caret) {
	checkWidget ();
	Caret newCaret = caret;
	Caret oldCaret = this.caret;
	this.caret = newCaret;
	if (oldCaret != null) {
		removeChild (oldCaret);
		if (hasFocus ()) oldCaret.killFocus ();
	}
	if (newCaret != null) {
		if (newCaret.isDisposed()) error(SWT.ERROR_INVALID_ARGUMENT);
		addChild (newCaret, parentingComponent().numChildren);
		if (hasFocus ()) newCaret.setFocus ();
	}
}

public void setFont (Font font) {
	checkWidget ();
	if (caret != null) caret.setFont (font);
	super.setFont (font);
}

public void setIME (IME ime) {
	checkWidget ();
	if (ime != null && ime.isDisposed()) error(SWT.ERROR_INVALID_ARGUMENT);
	this.ime = ime;
}
}
